% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_optim.R
\name{lm_optim}
\alias{lm_optim}
\title{Optimize parameters for onlineforecast model fitted with LM}
\usage{
lm_optim(
  model,
  data,
  scorefun = rmse,
  cachedir = "",
  printout = TRUE,
  method = "L-BFGS-B",
  ...
)
}
\arguments{
\item{model}{The onlineforecast model, including inputs, output, kseq, p}

\item{data}{The data.list including the variables used in the model.}

\item{scorefun}{The function to be score used for calculating the score to be optimized.}

\item{cachedir}{A character specifying the path (and prefix) of the cache file name. If set to \code{""}, then no cache will be loaded or written. See \url{https://onlineforecasting.org/vignettes/nice-tricks.html} for examples.}

\item{printout}{A logical determining if the score function is printed out in each iteration of the optimization.}

\item{method}{The method argument for \code{\link{optim}}.}

\item{...}{Additional parameters to \code{\link{optim}}}
}
\value{
Result object of optim().
Parameters resulting from the optimization can be found from \code{result$par}
}
\description{
Optimize parameters (transformation stage) of LM model
}
\details{
This is a wrapper for \code{\link{optim}} to enable easy use of bounds and caching in the optimization.
}
\examples{

# Take data
D <- subset(Dbuilding, c("2010-12-15", "2011-01-01"))
D$y <- D$heatload
# Define a simple model 
model <- forecastmodel$new()
model$add_inputs(Ta = "lp(Ta, a1=0.9)",
                 mu = "one()")
# Before fitting the model, define which points to include in the evaluation of the score function
D$scoreperiod <- in_range("2010-12-20", D$t)
# And the sequence of horizons to fit for
model$kseq <- 1:6

# Now we can fit the model and get the score, as it is
lm_fit(model=model, data=D, scorefun=rmse, returnanalysis=FALSE)
# Or we can change the low-pass filter coefficient
lm_fit(c(Ta__a1=0.99), model, D, rmse, returnanalysis=FALSE)

# This could be passed to optim() (or any optimizer).
# See \code{forecastmodel$insert_prm()} for more details.
optim(c(Ta__a1=0.98), lm_fit, model=model, data=D, scorefun=rmse, returnanalysis=FALSE,
      lower=c(Ta__a1=0.4), upper=c(Ta__a1=0.999), method="L-BFGS-B")

# lm_optim is simply a helper it makes using bounds easiere and enables caching of the results
# First add bounds for lambda (lower, init, upper)
model$add_prmbounds(Ta__a1 = c(0.4, 0.98, 0.999))

# Now the same optimization as above can be done by
val <- lm_optim(model, D)
val


}
\seealso{
\code{link{optim}} for how to control the optimization and \code{\link{rls_optim}} which works very similarly.
}
