% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sets.R
\name{remove_uninformative_terms}
\alias{remove_uninformative_terms}
\title{Remove uninformative terms from union of all terms in set of annotations}
\usage{
remove_uninformative_terms(ontology, term_sets)
}
\arguments{
\item{ontology}{\code{ontology_index} object}

\item{term_sets}{List of character vectors of ontological term IDs}
}
\value{
Character vector of terms
}
\description{
For a set of ontological annotation sets, remove terms annotated to the same objects as all their children. Useful for selecting terms for summarising a set of annotation sets, as it can lead to a significant reduction in the number of terms.
}
\examples{
library(ontologyIndex)
data(hpo)
remove_uninformative_terms(hpo, list(Patient1=c("HP:0001873","HP:0000118")))
}

