% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_sim_grid}
\alias{get_sim_grid}
\title{Get similarity matrix from a term-to-term similarity matrix between two sets of term sets}
\usage{
get_sim_grid(term_sim_mat, term_sets, term_sets2 = term_sets,
  combine = c("average", "product"))
}
\arguments{
\item{term_sim_mat}{Numeric matrix with rows and columns corresponding to (and named by) term IDs, and cells containing the similarity between the row and column term}

\item{term_sets}{List of character vectors of ontological term IDs.}

\item{term_sets2}{Second set of term sets}

\item{combine}{Character string - either \code{average} or \code{product}, indicating whether to use the `best-match-average' or `best-match-product' method}
}
\value{
Numeric matrix of between-term set similarities
}
\description{
Equivalent to \code{\link{get_sim_mat}} for two sets of term sets.
}

