% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group-sim.R
\name{get_sim}
\alias{get_sim}
\alias{get_sim.default}
\alias{get_sim.integer}
\alias{get_sim.matrix}
\alias{get_sim.numeric}
\alias{get_sim.sim_index}
\title{Calculate the group similarity of a set of row/column indices}
\usage{
get_sim(pop_sim, ...)

\method{get_sim}{integer}(pop_sim, ...)

\method{get_sim}{numeric}(pop_sim, group = seq(length(pop_sim)), ...)

\method{get_sim}{matrix}(pop_sim, group = seq(nrow(pop_sim)), ...)

\method{get_sim}{sim_index}(pop_sim, group = seq(pop_sim[["N"]]), ...)

\method{get_sim}{default}(pop_sim, group, type, group_sim = "average", ...)
}
\arguments{
\item{pop_sim}{An object representing the similarities of an indexed population of objects.}

\item{...}{Other arguments to be passed to \code{get_sim}.}

\item{group}{Character or integer vector specifying names/indices of subgroup for which to calculate a group similarity p-value.}

\item{type}{Either "matrix", "sim_index" or "numeric" - the type of the \code{pop_sim} object.}

\item{group_sim}{String Either "average" or "min", determining how to calculate the similarity of a group of term sets over all pairwise combinations of group members}
}
\value{
Numeric value of group similarity
}
\description{
Calculates the similarity of a group within a population by applying the function specified by \code{group_sim} to the pairwise similarities of group members.
}
\seealso{
\code{\link{get_sim_p}} \code{\link{sample_group_sim}}
}

