% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_functions.R
\name{make_pic}
\alias{make_pic}
\title{Assign colors to picture ID layers}
\usage{
make_pic(picture, layers, cols.maps)
}
\arguments{
\item{picture}{grImport object. A vector image imported in R using the 'readPicture' function from grImport.}

\item{layers}{numeric. A named vector where values indicate the layer IDs in the Picture object and names indicate the anatomy ontology term labels.}

\item{cols.maps}{character. A named vector where elements correspond to color IDs and names indicate the anatomy ontology term labels.}
}
\value{
An object of class 'Picture' with the assigned colors to different anatomical regions.
}
\description{
Assigns colors to picture ID layers (@paths) of an object of class 'Picture'.
The object should be a PS or ESP vector illustration imported using the grImport package.
Colors are taken from cols.maps argument were the palette indicates the scale of the desired statistics for the evolutionary rates.
}
\examples{
data("HAO", "hym_graph", "hym_img", "hym_kde")
# Get picture.
picture <- hym_img
# Get picture layers from three anatomical regions.
terms_list <- as.list(c("HAO:0000397", "HAO:0000576", "HAO:0000626"))
terms_list <- setNames(terms_list, c("head", "mesosoma", "metasoma"))
anat_layers <- get_vector_ids_list(terms = terms_list , ONT = HAO, GR = hym_graph)
# Get mean rates all branches for the three anatomical regions.
plot_stat <- lapply(hym_kde, function(x) unlist(lapply(x$loess.lambda.mean, function(x) mean(x) )) )
plot_stat <- do.call(cbind, plot_stat)
# Add two columns for the other anatomical regions (just for this example).
plot_stat <- cbind(plot_stat, plot_stat*0.75, plot_stat*0.5)
colnames(plot_stat) <- c("head", "mesosoma", "metasoma")
# Select an arbitrary branch.
plot_stat <- plot_stat[5,]
# Set scale.
scale_lim <- range(plot_stat)
# Get color palette.
hm.palette <- colorRampPalette(RColorBrewer::brewer.pal(9, "Spectral"), space = "Lab")
cols_maps <- make_colors_relative_scale(plot_stat, palette = hm.palette(100),
                                        lims = scale_lim)
# Plot picture.
new_pic <- make_pic(picture, anat_layers, cols_maps)
grImport::grid.picture(new_pic)

}
\author{
Sergei Tarasov
}
