% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object_class.R
\name{object_class}
\alias{object_class}
\alias{get_object_class}
\alias{object_classes}
\title{Get class of an object (possibly with inheritance)}
\usage{
object_class(object, ancestor = 0)

get_object_class(object, ancestor = 0, ...)

object_classes(..., objects = list(...))
}
\arguments{
\item{object}{\code{ANY} \cr Object to get the class of}

\item{ancestor}{\code{(integer(1))} \cr If greater than 0 then the given ancestor
to get the class for, see examples}

\item{...}{\code{ANY} \cr Objects to \code{vapply} over}

\item{objects}{\code{(list(1))} \cr Alternative constructor with \code{list} of objects}
}
\description{
Find class of an object or an ancestor of the object. In contrast to \code{class}
which returns a class object and all its ancestors, this function returns
either the class of the object itself, or the class of one of its ancestors.
}
\details{
\code{object_classes} is a stripped-down wrapper to get the class of multiple
objects
}
\examples{
library(R6)

class_a <- R6Class("class_a")
class_b <- R6Class("class_b", inherit = class_a)
class(class_b$new())
object_class(class_b$new())
object_class(class_b$new(), 1)
}
