% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.admin.R
\name{dsadmin.profile_init}
\alias{dsadmin.profile_init}
\title{Initialize a DataSHIELD profile}
\usage{
dsadmin.profile_init(opal, name, packages = NULL)
}
\arguments{
\item{opal}{Opal object.}

\item{name}{Name of the profile.}

\item{packages}{A list DataSHIELD R package names}
}
\description{
Clean the DataSHIELD's profile settings from all methods and options (including custom ones). These settings
are then repopulated with installed DataSHIELD R packages settings, optionaly filtered by the name.
See also \link{dsadmin.publish_package}, \link{dsadmin.set_package_methods} or \link{dsadmin.set_option}.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
dsadmin.profile_create(o, name = 'survival', cluster = 'demo')
dsadmin.profile_init(o, name = 'survival', packages = c('dsSurvival'))
opal.logout(o)
}
}
\seealso{
Other DataSHIELD profiles: 
\code{\link{dsadmin.profile_access}()},
\code{\link{dsadmin.profile_create}()},
\code{\link{dsadmin.profile_delete}()},
\code{\link{dsadmin.profile_enable}()},
\code{\link{dsadmin.profile_exists}()},
\code{\link{dsadmin.profile_perm_add}()},
\code{\link{dsadmin.profile_perm_delete}()},
\code{\link{dsadmin.profile_perm}()},
\code{\link{dsadmin.profile_rparser}()},
\code{\link{dsadmin.profiles}()},
\code{\link{dsadmin.profile}()}
}
\concept{DataSHIELD profiles}
