/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lang.english;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.tools.chunker.ChunkerContextGenerator;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.util.Sequence;

public class TreebankChunker
extends ChunkerME {
    public TreebankChunker(String modelFile) throws IOException {
        this((MaxentModel)new SuffixSensitiveGISModelReader(new File(modelFile)).getModel());
    }

    public TreebankChunker(MaxentModel mod) {
        super(mod);
    }

    public TreebankChunker(MaxentModel mod, ChunkerContextGenerator cg) {
        super(mod, cg);
    }

    public TreebankChunker(MaxentModel mod, ChunkerContextGenerator cg, int beamSize) {
        super(mod, cg, beamSize);
    }

    private boolean validOutcome(String outcome, String prevOutcome) {
        if (outcome.startsWith("I-")) {
            if (prevOutcome == null) {
                return false;
            }
            if (prevOutcome.equals("O")) {
                return false;
            }
            if (!prevOutcome.substring(2).equals(outcome.substring(2))) {
                return false;
            }
        }
        return true;
    }

    protected boolean validOutcome(String outcome, String[] sequence) {
        String prevOutcome = null;
        if (sequence.length > 0) {
            prevOutcome = sequence[sequence.length - 1];
        }
        return this.validOutcome(outcome, prevOutcome);
    }

    protected boolean validOutcome(String outcome, Sequence sequence) {
        String prevOutcome = null;
        List tagList = sequence.getOutcomes();
        int lti = tagList.size() - 1;
        if (lti >= 0) {
            prevOutcome = (String)tagList.get(lti);
        }
        return this.validOutcome(outcome, prevOutcome);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: java opennlp.tools.english.TreebankChunker model < tokenized_sentences");
            System.exit(1);
        }
        TreebankChunker chunker = new TreebankChunker(args[0]);
        BufferedReader inReader = new BufferedReader(new InputStreamReader(System.in));
        String line = inReader.readLine();
        while (line != null) {
            if (line.equals("")) {
                System.out.println();
            } else {
                String[] tts = line.split(" ");
                Object[] tokens = new String[tts.length];
                String[] tags = new String[tts.length];
                int tn = tts.length;
                for (int ti = 0; ti < tn; ++ti) {
                    String[] tt = tts[ti].split("/");
                    tokens[ti] = tt[0];
                    tags[ti] = tt[1];
                }
                String[] chunks = chunker.chunk(tokens, tags);
                int cn = chunks.length;
                for (int ci = 0; ci < cn; ++ci) {
                    if (ci > 0 && !chunks[ci].startsWith("I-") && !chunks[ci - 1].equals("O")) {
                        System.out.print(" ]");
                    }
                    if (chunks[ci].startsWith("B-")) {
                        System.out.print(" [" + chunks[ci].substring(2));
                    }
                    System.out.print(" " + (String)tokens[ci] + "/" + tags[ci]);
                }
                if (!chunks[chunks.length - 1].equals("O")) {
                    System.out.print(" ]");
                }
                System.out.println();
            }
            line = inReader.readLine();
        }
    }
}

