/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import opennlp.maxent.Counter;
import opennlp.maxent.Event;
import opennlp.maxent.EventCollector;
import opennlp.tools.postag.POSContextGenerator;
import opennlp.tools.util.Pair;

public class POSEventCollector
implements EventCollector {
    private BufferedReader br;
    private POSContextGenerator cg;

    public POSEventCollector(Reader data, POSContextGenerator gen) {
        this.br = new BufferedReader(data);
        this.cg = gen;
    }

    private static Pair split(String s) {
        int split = s.lastIndexOf("_");
        if (split == -1) {
            System.out.println("There is a problem in your training data: " + s + " does not conform to the format WORD_TAG.");
            return new Pair(s, "UNKNOWN");
        }
        return new Pair(s.substring(0, split), s.substring(split + 1));
    }

    public static Pair convertAnnotatedString(String s) {
        ArrayList<Object> tokens = new ArrayList<Object>();
        ArrayList<Object> outcomes = new ArrayList<Object>();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            Pair p = POSEventCollector.split(st.nextToken());
            tokens.add(p.a);
            outcomes.add(p.b);
        }
        return new Pair(tokens, outcomes);
    }

    public Event[] getEvents() {
        return this.getEvents(false);
    }

    private Set getFrequent(BufferedReader br) {
        HashMap<String, Counter> map = new HashMap<String, Counter>();
        try {
            String s = br.readLine();
            while (s != null) {
                StringTokenizer st = new StringTokenizer(s);
                while (st.hasMoreTokens()) {
                    String tok = (String)POSEventCollector.split((String)st.nextToken()).a;
                    Counter c = (Counter)map.get(tok);
                    if (c != null) {
                        c.increment();
                        continue;
                    }
                    map.put(tok, new Counter());
                }
                s = br.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashSet set = new HashSet();
        for (Map.Entry entry : map.entrySet()) {
            if (!((Counter)entry.getValue()).passesCutoff(5)) continue;
            set.add(entry.getKey());
        }
        return set;
    }

    public Event[] getEvents(boolean evalMode) {
        ArrayList<Event> elist = new ArrayList<Event>();
        try {
            String s = this.br.readLine();
            while (s != null) {
                Pair p = POSEventCollector.convertAnnotatedString(s);
                ArrayList tokens = (ArrayList)p.a;
                ArrayList outcomes = (ArrayList)p.b;
                ArrayList tags = new ArrayList();
                for (int i = 0; i < tokens.size(); ++i) {
                    String[] context = this.cg.getContext(i, tokens.toArray(), tags.toArray(new String[tags.size()]), null);
                    Event e = new Event((String)outcomes.get(i), context);
                    tags.add(outcomes.get(i));
                    elist.add(e);
                }
                s = this.br.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Event[] events = new Event[elist.size()];
        for (int i = 0; i < events.length; ++i) {
            events[i] = (Event)elist.get(i);
        }
        return events;
    }
}

