/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import opennlp.model.AbstractModel;
import opennlp.model.Event;
import opennlp.model.Sequence;
import opennlp.model.SequenceStream;
import opennlp.tools.namefind.DefaultNameContextGenerator;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.NameFinderEventStream;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleSequenceIterator;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameSampleSequenceStream
implements SequenceStream {
    private NameContextGenerator pcg;
    private List<NameSample> samples = new ArrayList<NameSample>();

    public NameSampleSequenceStream(ObjectStream<NameSample> psi) throws IOException {
        this(psi, new DefaultNameContextGenerator(new AdaptiveFeatureGenerator[]{null}));
    }

    public NameSampleSequenceStream(ObjectStream<NameSample> psi, AdaptiveFeatureGenerator featureGen) throws IOException {
        this(psi, new DefaultNameContextGenerator(featureGen));
    }

    public NameSampleSequenceStream(ObjectStream<NameSample> psi, NameContextGenerator pcg) throws IOException {
        NameSample sample;
        while ((sample = psi.read()) != null) {
            this.samples.add(sample);
        }
        System.err.println("Got " + this.samples.size() + " sequences");
        this.pcg = pcg;
    }

    @Override
    public Event[] updateContext(Sequence sequence, AbstractModel model) {
        Sequence pss = sequence;
        NameFinderME tagger = new NameFinderME(new TokenNameFinderModel("x-unspecified", model, Collections.<String, Object>emptyMap(), null));
        String[] sentence = ((NameSample)pss.getSource()).getSentence();
        String[] tags = NameFinderEventStream.generateOutcomes(tagger.find(sentence), null, sentence.length);
        Event[] events = new Event[sentence.length];
        NameFinderEventStream.generateEvents(sentence, tags, this.pcg).toArray(events);
        return events;
    }

    @Override
    public Iterator<Sequence> iterator() {
        return new NameSampleSequenceIterator(this.samples.iterator());
    }
}

