/*
 * Decompiled with CFR 0.152.
 */
package opennlp.model;

import java.io.IOException;
import java.util.Map;
import opennlp.maxent.GIS;
import opennlp.maxent.quasinewton.QNTrainer;
import opennlp.model.AbstractDataIndexer;
import opennlp.model.AbstractModel;
import opennlp.model.EventStream;
import opennlp.model.HashSumEventStream;
import opennlp.model.OnePassDataIndexer;
import opennlp.model.SequenceStream;
import opennlp.model.TwoPassDataIndexer;
import opennlp.perceptron.PerceptronTrainer;
import opennlp.perceptron.SimplePerceptronSequenceTrainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrainUtil {
    public static final String ALGORITHM_PARAM = "Algorithm";
    public static final String MAXENT_VALUE = "MAXENT";
    public static final String MAXENT_QN_VALUE = "MAXENT_QN_EXPERIMENTAL";
    public static final String PERCEPTRON_VALUE = "PERCEPTRON";
    public static final String PERCEPTRON_SEQUENCE_VALUE = "PERCEPTRON_SEQUENCE";
    public static final String CUTOFF_PARAM = "Cutoff";
    private static final int CUTOFF_DEFAULT = 5;
    public static final String ITERATIONS_PARAM = "Iterations";
    private static final int ITERATIONS_DEFAULT = 100;
    public static final String DATA_INDEXER_PARAM = "DataIndexer";
    public static final String DATA_INDEXER_ONE_PASS_VALUE = "OnePass";
    public static final String DATA_INDEXER_TWO_PASS_VALUE = "TwoPass";

    private static String getStringParam(Map<String, String> trainParams, String key, String defaultValue, Map<String, String> reportMap) {
        String valueString = trainParams.get(key);
        if (valueString == null) {
            valueString = defaultValue;
        }
        if (reportMap != null) {
            reportMap.put(key, valueString);
        }
        return valueString;
    }

    private static int getIntParam(Map<String, String> trainParams, String key, int defaultValue, Map<String, String> reportMap) {
        String valueString = trainParams.get(key);
        if (valueString != null) {
            return Integer.parseInt(valueString);
        }
        return defaultValue;
    }

    private static double getDoubleParam(Map<String, String> trainParams, String key, double defaultValue, Map<String, String> reportMap) {
        String valueString = trainParams.get(key);
        if (valueString != null) {
            return Double.parseDouble(valueString);
        }
        return defaultValue;
    }

    private static boolean getBooleanParam(Map<String, String> trainParams, String key, boolean defaultValue, Map<String, String> reportMap) {
        String valueString = trainParams.get(key);
        if (valueString != null) {
            return Boolean.parseBoolean(valueString);
        }
        return defaultValue;
    }

    public static boolean isValid(Map<String, String> trainParams) {
        String algorithmName = trainParams.get(ALGORITHM_PARAM);
        if (!(algorithmName == null || MAXENT_VALUE.equals(algorithmName) || MAXENT_QN_VALUE.equals(algorithmName) || PERCEPTRON_VALUE.equals(algorithmName) || PERCEPTRON_SEQUENCE_VALUE.equals(algorithmName))) {
            return false;
        }
        try {
            String iterationsString;
            String cutoffString = trainParams.get(CUTOFF_PARAM);
            if (cutoffString != null) {
                Integer.parseInt(cutoffString);
            }
            if ((iterationsString = trainParams.get(ITERATIONS_PARAM)) != null) {
                Integer.parseInt(iterationsString);
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        String dataIndexer = trainParams.get(DATA_INDEXER_PARAM);
        return dataIndexer == null || DATA_INDEXER_ONE_PASS_VALUE.equals(dataIndexer) || DATA_INDEXER_TWO_PASS_VALUE.equals(dataIndexer);
    }

    public static AbstractModel train(EventStream events, Map<String, String> trainParams, Map<String, String> reportMap) throws IOException {
        AbstractModel model;
        boolean sortAndMerge;
        if (!TrainUtil.isValid(trainParams)) {
            throw new IllegalArgumentException("trainParams are not valid!");
        }
        if (TrainUtil.isSequenceTraining(trainParams)) {
            throw new IllegalArgumentException("sequence training is not supported by this method!");
        }
        String algorithmName = TrainUtil.getStringParam(trainParams, ALGORITHM_PARAM, MAXENT_VALUE, reportMap);
        int iterations = TrainUtil.getIntParam(trainParams, ITERATIONS_PARAM, 100, reportMap);
        int cutoff = TrainUtil.getIntParam(trainParams, CUTOFF_PARAM, 5, reportMap);
        if (MAXENT_VALUE.equals(algorithmName) || MAXENT_QN_VALUE.equals(algorithmName)) {
            sortAndMerge = true;
        } else if (PERCEPTRON_VALUE.equals(algorithmName)) {
            sortAndMerge = false;
        } else {
            throw new IllegalStateException("Unexpected algorithm name: " + algorithmName);
        }
        HashSumEventStream hses = new HashSumEventStream(events);
        String dataIndexerName = TrainUtil.getStringParam(trainParams, DATA_INDEXER_PARAM, DATA_INDEXER_TWO_PASS_VALUE, reportMap);
        AbstractDataIndexer indexer = null;
        if (DATA_INDEXER_ONE_PASS_VALUE.equals(dataIndexerName)) {
            indexer = new OnePassDataIndexer(hses, cutoff, sortAndMerge);
        } else if (DATA_INDEXER_TWO_PASS_VALUE.equals(dataIndexerName)) {
            indexer = new TwoPassDataIndexer(hses, cutoff, sortAndMerge);
        } else {
            throw new IllegalStateException("Unexpected data indexer name: " + dataIndexerName);
        }
        if (MAXENT_VALUE.equals(algorithmName)) {
            int threads = TrainUtil.getIntParam(trainParams, "Threads", 1, reportMap);
            model = GIS.trainModel(iterations, indexer, true, false, null, 0, threads);
        } else if (MAXENT_QN_VALUE.equals(algorithmName)) {
            int m = TrainUtil.getIntParam(trainParams, "numOfUpdates", 7, reportMap);
            int maxFctEval = TrainUtil.getIntParam(trainParams, "maxFctEval", 300, reportMap);
            model = new QNTrainer(m, maxFctEval, true).trainModel(indexer);
        } else if (PERCEPTRON_VALUE.equals(algorithmName)) {
            boolean useAverage = TrainUtil.getBooleanParam(trainParams, "UseAverage", true, reportMap);
            boolean useSkippedAveraging = TrainUtil.getBooleanParam(trainParams, "UseSkippedAveraging", false, reportMap);
            if (useSkippedAveraging) {
                useAverage = true;
            }
            double stepSizeDecrease = TrainUtil.getDoubleParam(trainParams, "StepSizeDecrease", 0.0, reportMap);
            double tolerance = TrainUtil.getDoubleParam(trainParams, "Tolerance", 1.0E-5, reportMap);
            PerceptronTrainer perceptronTrainer = new PerceptronTrainer();
            perceptronTrainer.setSkippedAveraging(useSkippedAveraging);
            if (stepSizeDecrease > 0.0) {
                perceptronTrainer.setStepSizeDecrease(stepSizeDecrease);
            }
            perceptronTrainer.setTolerance(tolerance);
            model = perceptronTrainer.trainModel(iterations, indexer, cutoff, useAverage);
        } else {
            throw new IllegalStateException("Algorithm not supported: " + algorithmName);
        }
        if (reportMap != null) {
            reportMap.put("Training-Eventhash", hses.calculateHashSum().toString(16));
        }
        return model;
    }

    public static boolean isSequenceTraining(Map<String, String> trainParams) {
        return PERCEPTRON_SEQUENCE_VALUE.equals(trainParams.get(ALGORITHM_PARAM));
    }

    public static AbstractModel train(SequenceStream events, Map<String, String> trainParams, Map<String, String> reportMap) throws IOException {
        if (!TrainUtil.isValid(trainParams)) {
            throw new IllegalArgumentException("trainParams are not valid!");
        }
        if (!TrainUtil.isSequenceTraining(trainParams)) {
            throw new IllegalArgumentException("Algorithm must be a sequence algorithm!");
        }
        int iterations = TrainUtil.getIntParam(trainParams, ITERATIONS_PARAM, 100, reportMap);
        int cutoff = TrainUtil.getIntParam(trainParams, CUTOFF_PARAM, 5, reportMap);
        boolean useAverage = TrainUtil.getBooleanParam(trainParams, "UseAverage", true, reportMap);
        return new SimplePerceptronSequenceTrainer().trainModel(iterations, events, cutoff, useAverage);
    }
}

