% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajLevelMap.R
\name{trajLevelMap}
\alias{trajLevelMap}
\title{Trajectory level plots in leaflet}
\usage{
trajLevelMap(
  data,
  longitude = "lon",
  latitude = "lat",
  pollutant = "nox",
  statistic = "frequency",
  percentile = 90,
  lon.inc = 1,
  lat.inc = 1,
  min.bin = 1,
  cols = "default",
  alpha = 0.5,
  provider = "OpenStreetMap"
)
}
\arguments{
\item{data}{Data frame, the result of importing a trajectory file using
\code{\link[openair:importTraj]{openair::importTraj()}}.}

\item{longitude}{Column containing the longitude, as a decimal.}

\item{latitude}{Column containing the latitude, as a decimal.}

\item{pollutant}{Pollutant to be plotted.}

\item{statistic}{By default the function will plot the trajectory
frequencies. There are also various ways of plotting concentrations.

It is also possible to set \code{statistic = "difference"}. In this case
trajectories where the associated concentration is greater than
\code{percentile} are compared with the the full set of trajectories to
understand the differences in frequencies of the origin of air masses. The
comparison is made by comparing the percentage change in gridded
frequencies. For example, such a plot could show that the top 10\\% of
concentrations of PM10 tend to originate from air-mass origins to the east.

If \code{statistic = "pscf"} then a Potential Source Contribution Function
map is produced. If \code{statistic = "cwt"} then the Concentration
Weighted Trajectory approach is used. If \code{statistic = "saqn"} then
Simplified Quantitative Transport Bias Analysis is used. See "details" of
\code{\link[openair:trajLevel]{openair::trajLevel()}} for more information.}

\item{percentile}{For \code{\link[openair:trajLevel]{openair::trajLevel()}}. The percentile concentration of
\code{pollutant} against which the all trajectories are compared.}

\item{lon.inc}{The longitude-interval to be used for binning data.}

\item{lat.inc}{The latitude-interval to be used for binning data.}

\item{min.bin}{The minimum number of unique points in a grid cell. Counts
below \code{min.bin} are set as missing.}

\item{cols}{Colours to be used for plotting. Options include
\dQuote{default}, \dQuote{increment}, \dQuote{heat}, \dQuote{jet} and
\code{\link[RColorBrewer:ColorBrewer]{RColorBrewer::brewer.pal()}} colours — see the \code{\link[openair:openColours]{openair::openColours()}}
function for more details. For user defined the user can supply a list of
colour names recognised by R (type \code{\link[grDevices:colors]{grDevices::colours()}} to see the full
list). An example would be \code{cols = c("yellow", "green", "blue")}.}

\item{alpha}{Opacity of the tiles. Must be between \code{0} and \code{1}.}

\item{provider}{The base map(s) to be used. See
\url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list
of all base maps that can be used. If multiple base maps are provided, they
can be toggled between using a "layer control" interface.}
}
\value{
A leaflet object.
}
\description{
This function plots back trajectories on a \code{leaflet} map. This function
requires that data are imported using the \code{\link[openair:importTraj]{openair::importTraj()}} function.
}
\examples{
\dontrun{
trajLevelMap(traj_data, pollutant = "pm2.5", statistic = "pscf", min.bin = 10)
}

}
