% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setlanguage_odf.R
\name{setlanguage_odf}
\alias{setlanguage_odf}
\title{Change language of dataframe metadata}
\usage{
setlanguage_odf(dataframe, language)
}
\arguments{
\item{dataframe}{R data frame (df) enriched with metadata in the
odf-format.}

\item{language}{Select the language to which you want to switch the metadata.}
}
\value{
Dataframe
}
\description{
Changes the active language of a dataframe with metadata for the
docu_odf function.
}
\examples{
# get example data from the opendataformat package
df  <-  get(data("data_odf"))

# Switch dataset df to language "en"
df  <-  setlanguage_odf(df, language = "en")

# Display dataset information for dataset df in language "en"
docu_odf(df)

}
