% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_types.R
\name{ProcessGraphArgument}
\alias{ProcessGraphArgument}
\title{ProcessGraphArgument}
\value{
Object of \code{\link{R6Class}} representing a ProcessGraph.
}
\description{
Inheriting from \code{\link{Argument}} in order to represent a ProcessGraph (prior known as callback). The ProcessGraph operates on reduced data
of a data cube. For example reducing the time dimension results in a time series that has to be reduced into a
single value. The value of a ProcessGraph is usually a \code{\link{Graph}} with \code{\link{ProcessGraphParameter}} as 
added data. Additional information can be found in the openEO API documentation:
\itemize{
  \item \url{https://api.openeo.org/#section/Processes/Process-Graphs}
}
}
\section{Methods}{

\describe{
  \item{\code{$getProcessGraphParameters()}}{returns the available list \code{\link{ProcessGraphParameter}}}
  \item{\code{$setProcessGraphParameters(parameters)}}{assigns a list of \code{\link{ProcessGraphParameter}} to the ProcessGraph}
}
}

\section{Arguments}{

\describe{
  \item{\code{parameters}}{the \code{\link{ProcessGraphParameter}} list}
}
}

\seealso{
\code{\link{Array}}, \code{\link{Integer}}, \code{\link{EPSGCode}}, \code{\link{String}}, \code{\link{Number}}, 
\code{\link{Date}}, \code{\link{RasterCube}}, \code{\link{VectorCube}}, \code{\link{ProcessGraphArgument}}, 
\code{\link{ProcessGraphParameter}}, \code{\link{OutputFormatOptions}}, \code{\link{GeoJson}},
\code{\link{Boolean}}, \code{\link{DateTime}}, \code{\link{Time}}, \code{\link{BoundingBox}}, \code{\link{Kernel}}, 
\code{\link{TemporalInterval}}, \code{\link{TemporalIntervals}}, \code{\link{CollectionId}}, \code{\link{OutputFormat}},
\code{\link{AnyOf}}, \code{\link{ProjDefinition}}, \code{\link{UdfCodeArgument}}, \code{\link{UdfRuntimeArgument}} and 
\code{\link{UdfRuntimeVersionArgument}},\code{\link{TemporalIntervals}}, \code{\link{MetadataFilter}}
}
