% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobs.R
\name{create_job}
\alias{create_job}
\title{Creates a new job on the back-end}
\usage{
create_job(
  graph = NULL,
  title = NULL,
  description = NULL,
  plan = NULL,
  budget = NULL,
  con = NULL,
  ...
)
}
\arguments{
\item{graph}{A \code{\link[=Graph]{Graph()}}, a function returning a \code{\link[=ProcessNode]{ProcessNode()}} as an endpoint or the \code{\link[=ProcessNode]{ProcessNode()}}
will return the results}

\item{title}{Optional title of a job}

\item{description}{Optional detailed information about a job}

\item{plan}{An optional execution plan offered by the back-end, determining how the job will be executed}

\item{budget}{An optional budget, which sets the maximum amount of credits to be used by the job}

\item{con}{connected and authenticated openEO client (optional) otherwise \code{\link[=active_connection]{active_connection()}}
is used.}

\item{...}{additional parameters passed to jsonlite::toJSON() (like 'digits')}
}
\value{
the id of the job
}
\description{
In preparation to execute the users analysis workflow (user defined process) asynchronously, they need to register a job that
will be scheduled when the required resources are available. To do so the user provides the process graph with optional descriptive meta
data and the desired execution plan or the maximum amount of credits spent.
}
