% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-babies_crawl.R
\docType{data}
\name{babies_crawl}
\alias{babies_crawl}
\title{Crawling age}
\format{
A data frame with 12 observations on the following 5 variables.
\describe{
  \item{birth_month}{A factor with levels corresponding to months}
  \item{avg_crawling_age}{a numeric vector}
  \item{sd}{a numeric vector}
  \item{n}{a numeric vector}
  \item{temperature}{a numeric vector}
  }
}
\source{
J.B. Benson. Season of birth and onset of locomotion: Theoretical
and methodological implications. In: Infant behavior and development 16.1
(1993), pp. 69-81. issn: 0163-6383.
}
\usage{
babies_crawl
}
\description{
Crawling age of babies along with the average outdoor temperature at 6
months of age.
}
\examples{

library(ggplot2)

ggplot(babies_crawl, aes(x = temperature, y = avg_crawling_age)) +
  geom_point() +
  labs(x = "Temperature", y = "Average crawling age")

}
\keyword{datasets}
