
if(!file.exists("../windows/libopenmpt/include/libopenmpt.h")){
  unlink("../windows", recursive = TRUE)
  url <- if(grepl("aarch", R.version$platform)){
    "https://github.com/r-windows/bundles/releases/download/libopenmpt-0.7.10/libopenmpt-0.7.10-clang-aarch64.tar.xz"
  } else if(grepl("clang", Sys.getenv('R_COMPILED_BY'))){
    "https://github.com/r-windows/bundles/releases/download/libopenmpt-0.7.10/libopenmpt-0.7.10-clang-x86_64.tar.xz"
  } else if(getRversion() >= "4.2") {
    "https://github.com/r-windows/bundles/releases/download/libopenmpt-0.7.10/libopenmpt-0.7.10-ucrt-x86_64.tar.xz"
  } else {
    stop("This package requires at least R-4.2 on Windows")
  }
  download.file(url, basename(url), quiet = TRUE)
  dir.create("../windows", showWarnings = FALSE)
  untar(basename(url), exdir = "../windows", tar = 'internal')
  unlink(basename(url))
  oldwd <- getwd()
  setwd("../windows")
  file.rename(list.files(), 'libopenmpt')
  setwd(oldwd)
}
