% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenomena.R
\name{osem_phenomena}
\alias{osem_phenomena}
\alias{osem_phenomena.sensebox}
\title{Get the counts of sensors for each observed phenomenon.}
\usage{
osem_phenomena(boxes)

\method{osem_phenomena}{sensebox}(boxes)
}
\arguments{
\item{boxes}{A \code{sensebox data.frame} of boxes}
}
\value{
A named \code{list} containing the count of sensors observing a
  phenomenon per phenomenon
}
\description{
Get the counts of sensors for each observed phenomenon.
}
\section{Methods (by class)}{
\itemize{
\item \code{osem_phenomena(sensebox)}: Get counts of sensors observing each phenomenon
from a set of senseBoxes.

}}
\examples{
# get the phenomena for a single senseBox
osem_phenomena(osem_box('593bcd656ccf3b0011791f5a'))

\donttest{
  # get the phenomena for a group of senseBoxes
  osem_phenomena(
    osem_boxes(grouptag = 'ifgi', exposure = 'outdoor', date = Sys.time())
  )

  # get phenomena with at least 30 sensors on opensensemap
  phenoms = osem_phenomena(osem_boxes())
  names(phenoms[phenoms > 29])
}
}
\seealso{
\code{\link{osem_boxes}}
}
