% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_owf.R
\name{get_owf}
\alias{get_owf}
\title{Retrieve Scada data from ENGIE's open wind farm}
\usage{
get_owf(wind_turbine = c("R80711", "R80790", "R80721", "R80736"), start_date,
  end_date, ...)
}
\arguments{
\item{wind_turbine}{character or numeric. The name or the number of the desired wind turbine,
among the four wind turbines available called \code{"R80711"} (or \code{1}),
\code{"R80790"} (or \code{2}), \code{"R80721"} (or \code{3}),
and \code{"R80736"} (or \code{4}).}

\item{start_date, end_date}{character or \code{\link{POSIXct}}.
Can have any format recognized by the \code{\link{anytime}} function.
Should be between \code{"2009-01-01 00:10:00"} and the current date.}

\item{...}{Additional parameters to be passed to \code{\link[httr]{GET}}.}
}
\value{
The dataset downloaded is returned invisibly.
}
\description{
The wind farm called `La Haute Borne' is located in the Meuse department in France,
and is made of four Senvion MM82 wind turbines commissioned in January, 15th, 2009.

In addition to the columns 'Wind_turbine_name' and the 'Date_time',
the dataset is made of 136 columns, which record every 10 minutes the average, the minimum,
the maximum, and the standard deviation over 10 minutes of 34 measurements
related to the operational behavior of the 4 wind turbines.

The dataset describing these 34 measurements can be retrieved with the
\code{\link[openwindfarm]{get_info}} function.
}
\note{
The dataset (not directly part of the \pkg{openwindfarm} package) is distributed
by \href{http://www.engie.com}{the ENGIE Group} under the terms of the
\href{https://www.etalab.gouv.fr/wp-content/uploads/2017/04/ETALAB-Licence-Ouverte-v2.0.pdf}{Open Licence 2.0},
provided by \href{https://www.etalab.gouv.fr/en/qui-sommes-nous}{Etalab} and
designed to be compatible notably with the "Creative Commons Attribution 4.0"
(CC-BY 4.0) license of Creative Commons.
}
\examples{
\dontrun{
df <- get_owf(wind_turbine = "R80711",
              start_date = "2012-12-10 00:10:00",
              end_date = "2013-01-15 03:30:00")
}

}
\seealso{
\code{\link[openwindfarm]{get_info}}.
}
