% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{sheetVisibility}
\alias{sheetVisibility}
\alias{sheetVisibility<-}
\title{Get/set worksheet visible state}
\usage{
sheetVisibility(wb)

sheetVisibility(wb) <- value
}
\arguments{
\item{wb}{A workbook object}

\item{value}{a logical/character vector the same length as sheetVisibility(wb)}
}
\value{
Character vector of worksheet names.

Vector of "hidden", "visible", "veryHidden"
}
\description{
Get and set worksheet visible state
}
\examples{

wb <- createWorkbook()
addWorksheet(wb, sheetName = "S1", visible = FALSE)
addWorksheet(wb, sheetName = "S2", visible = TRUE)
addWorksheet(wb, sheetName = "S3", visible = FALSE)

sheetVisibility(wb)
sheetVisibility(wb)[1] <- TRUE ## show sheet 1
sheetVisibility(wb)[2] <- FALSE ## hide sheet 2
sheetVisibility(wb)[3] <- "hidden" ## hide sheet 3
sheetVisibility(wb)[3] <- "veryHidden" ## hide sheet 3 from UI

}

