% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_clone_worksheet}
\alias{wb_clone_worksheet}
\title{Clone a worksheet to a workbook}
\usage{
wb_clone_worksheet(wb, old = current_sheet(), new = next_sheet())
}
\arguments{
\item{wb}{A \link{wbWorkbook} object}

\item{old}{Name of existing worksheet to copy}

\item{new}{Name of New worksheet to create}
}
\value{
The \code{wb} object
}
\description{
Clone a worksheet to a Workbook object
}
\examples{
# Create a new workbook
wb <- wb_workbook("Fred")

# Add worksheets
wb$add_worksheet("Sheet 1")
wb$clone_worksheet("Sheet 1", "Sheet 2")
}
\seealso{
Other workbook wrappers: 
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_creators}},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_get_base_font}()},
\code{\link{wb_save}()},
\code{\link{wb_set_col_widths}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_set_row_heights}()},
\code{\link{wb_workbook}()},
\code{\link{workbook_grouping}},
\code{\link{ws_cell_merge}}
}
\concept{workbook wrappers}
