% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_remove_col_widths}
\alias{wb_remove_col_widths}
\title{Remove column widths from a worksheet}
\usage{
wb_remove_col_widths(wb, sheet = current_sheet(), cols)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{cols}{Indices of columns to remove custom width (if any) from.}
}
\description{
Remove column widths from a worksheet
}
\examples{
## Create a new workbook
wb <- wb_load(file = system.file("extdata", "openxlsx2_example.xlsx", package = "openxlsx2"))

## remove column widths in columns 1 to 20
wb_remove_col_widths(wb, 1, cols = 1:20)
}
\seealso{
\code{\link[=wb_set_col_widths]{wb_set_col_widths()}}
}
