% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_set_sheetview}
\alias{wb_set_sheetview}
\title{add sheetview}
\usage{
wb_set_sheetview(
  wb,
  sheet = current_sheet(),
  color_id = NULL,
  default_grid_color = NULL,
  right_to_left = NULL,
  show_formulas = NULL,
  show_grid_lines = NULL,
  show_outline_symbols = NULL,
  show_row_col_headers = NULL,
  show_ruler = NULL,
  show_white_space = NULL,
  show_zeros = NULL,
  tab_selected = NULL,
  top_left_cell = NULL,
  view = NULL,
  window_protection = NULL,
  workbook_view_id = NULL,
  zoom_scale = NULL,
  zoom_scale_normal = NULL,
  zoom_scale_page_layout_view = NULL,
  zoom_scale_sheet_layout_view = NULL,
  ...
)
}
\arguments{
\item{wb}{workbook}

\item{sheet}{sheet}

\item{color_id, default_grid_color}{Integer: A color, default is 64}

\item{right_to_left}{Logical: if TRUE column ordering is right  to left}

\item{show_formulas}{Logical: if TRUE cell formulas are shown}

\item{show_grid_lines}{Logical: if TRUE the worksheet grid is shown}

\item{show_outline_symbols}{Logical: if TRUE outline symbols are shown}

\item{show_row_col_headers}{Logical: if TRUE row and column headers are shown}

\item{show_ruler}{Logical: if TRUE a ruler is shown in page layout view}

\item{show_white_space}{Logical: if TRUE margins are shown in page layout view}

\item{show_zeros}{Logical: if FALSE cells containing zero are shown blank if !showFormulas}

\item{tab_selected}{Integer: zero vector indicating the selected tab}

\item{top_left_cell}{Cell: the cell shown in the top left corner / or top right with rightToLeft}

\item{view}{View: "normal", "pageBreakPreview" or "pageLayout"}

\item{window_protection}{Logical: if TRUE the panes are protected}

\item{workbook_view_id}{integer: Pointing to some other view inside the workbook}

\item{zoom_scale, zoom_scale_normal, zoom_scale_page_layout_view, zoom_scale_sheet_layout_view}{Integer: the zoom scale should be between 10 and 400. These are values for current, normal etc.}

\item{...}{additional arguments}
}
\value{
The \code{wbWorksheetObject}, invisibly
}
\description{
add sheetview
}
\examples{
wb <- wb_workbook()$add_worksheet()

wb$set_sheetview(
  zoomScale = 75,
  rightToLeft = FALSE,
  showFormulas = TRUE,
  showGridLines = TRUE,
  showOutlineSymbols = FALSE,
  showRowColHeaders = TRUE,
  showRuler = TRUE,
  showWhiteSpace = FALSE,
  tabSelected = 1,
  topLeftCell = "B1",
  view = "normal",
  windowProtection = TRUE
)
}
