\name{opm_files}
\alias{opm_files}
\title{Opm files}
\usage{
  opm_files(what = c("scripts", "testdata", "auxiliary", "examples", "doc"))
}
\arguments{
  \item{what}{Character scalar indicating the subdirectory
  to search in.  Currently the following ones are included:
  \describe{ \item{auxiliary}{Miscellaneous files which are
  neither executable scripts nor test data. For instance,
  predefined \acronym{CSS} files for \acronym{HTML} files
  generated by \code{\link{phylo_data}} are found here.}
  \item{doc}{The vignette (documentation) in several
  formats, including the extracted \R code.}
  \item{examples}{Example \R code using the \pkg{opm}
  package that neither fitted into these help pages nor
  into the vignette.} \item{scripts}{\R script files for
  non-interactive uses of the \pkg{opm} package,
  particularly for the batch processing of many files.
  When called without input arguments or with the
  \sQuote{-h} switch, the scripts output usage
  information.} \item{testdata}{Files as output by the
  OmniLog\eqn{\textsuperscript{\textregistered}}{(R)}
  instrument for testing data input and metadata
  management.} }}
}
\value{
  Character vector of filenames.
}
\description{
  Get list of files from the \pkg{opm} package of interest
  for the user.
}
\note{
  This might fail with very unusual installations of the
  \pkg{opm} package.
}
\examples{
isRfile <- function(x) grepl("\\\.R$", x, ignore.case = TRUE)
(x <- opm_files("auxiliary"))
stopifnot(!isRfile(x))
(x <- opm_files("doc"))
stopifnot(!all(isRfile(x)), any(isRfile(x)))
(x <- opm_files("examples"))
stopifnot(isRfile(x))
(x <- opm_files("scripts"))
stopifnot(isRfile(x))
(x <- opm_files("testdata"))
stopifnot(!isRfile(x))

# On UNIX systems you should be able to do this if Rscript and the optparse
# package are properly installed:
# invisible(sapply(paste("Rscript", opm_files()), system))
# ...and get the usage messages of all scripts.
}
\seealso{
  pkgutils::pkg_files

  Other io-functions: \code{\link{batch_collect}},
  \code{\link{batch_opm}}, \code{\link{batch_opm_to_yaml}},
  \code{\link{batch_process}},
  \code{\link{clean_filenames}},
  \code{\link{collect_template}},
  \code{\link{explode_dir}}, \code{\link{file_pattern}},
  \code{\link{read_opm}}, \code{\link{read_single_opm}},
  \code{\link{split_files}}, \code{\link{to_metadata}}
}
\keyword{utilities}

