\name{optR.gauss}
\alias{optR.gauss}
\title{gauss to solve linear systems}
\usage{
\method{optR}{gauss}(A, b, tol = 1e-07)
}
\arguments{
  \item{A}{: Input Matrix}

  \item{b}{: Response}

  \item{method}{: To be used to perform factorization}

  \item{tol}{: Tolerance}
}
\value{
U : Upper triangular matrix

c : Transformed b

beta : Estimates
}
\description{
Function solves linear systems using Gauss Elimination. The
function solves equation of form Ax=b to Ux=c (where U is
upper triangular matrix)
}
\examples{
A<-matrix(c(0,-1,1, -1,2,-1,2,-1,0), nrow=3,ncol=3, byrow = TRUE)
b<-matrix(c(0,0, 1), nrow=3,ncol=1,byrow=TRUE)
Z<-optR(A, b, method="gauss")
}

