% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wf_mult.R
\name{DsWFMult}
\alias{DsWFMult}
\title{Cocktail Algorithm implementation for Ds-Optimality}
\usage{
DsWFMult(
  init_design,
  grad,
  par_int,
  min,
  max,
  grid.length,
  join_thresh,
  delete_thresh,
  delta_weights,
  tol,
  tol2
)
}
\arguments{
\item{init_design}{with the initial design for the algorithm. A dataframe with two columns:
\itemize{
\item \code{Point} contains the support points of the design.
\item \code{Weight} contains the corresponding weights of the \code{Point}s.
}}

\item{grad}{function of partial derivatives of the model.}

\item{par_int}{numeric vector with the index of the \code{parameters} of interest. Only necessary when
the \code{Criterion} chosen is 'Ds-Optimality'.}

\item{min}{numeric value with the inferior bound of the space of the design.}

\item{max}{numeric value with the upper bound of the space of the design.}

\item{grid.length}{numeric value that gives the grid to evaluate the sensitivity function when looking for a
maximum.}

\item{join_thresh}{numeric value that states how close, in real units, two points must be in order to
be joined together by the join heuristic.}

\item{delete_thresh}{numeric value with the minimum weight, over 1 total, that a point needs to have
in order to not be deleted from the design.}

\item{delta_weights}{numeric value in (0, 1), parameter of the algorithm.}

\item{tol}{numeric value for the convergence of the weight optimizing algorithm.}

\item{tol2}{numeric value for the stop condition of the algorithm.}
}
\value{
list correspondent to the output of the correspondent algorithm called, dependent on the criterion.
A list of two objects:
\itemize{
\item optdes: a dataframe with the optimal design in two columns, \code{Point} and \code{Weight}.
\item sens: a plot with the sensitivity function to check for optimality of the design.
}
}
\description{
Function that calculates the Ds-Optimal designs for the interest parameters given by \code{intPar}. The
rest of the parameters can help the convergence of the algorithm.
}
\seealso{
Other cocktail algorithms: 
\code{\link{DWFMult}()},
\code{\link{IWFMult}()},
\code{\link{WFMult}()}
}
\concept{cocktail algorithms}
