% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inf_mat_sens.R
\name{gradient}
\alias{gradient}
\title{Gradient function}
\usage{
gradient(model, char_vars, values, weight_fun = function(x) 1)
}
\arguments{
\item{model}{A formula describing the model, which must contain only \code{x}, the parameters defined in
\code{char_vars} and the numerical operators.}

\item{char_vars}{A character vector of the parameters of the model.}

\item{values}{Numeric vector with the nominal values of the parameters in \code{char_vars}.}

\item{weight_fun}{Optional one variable function that represents the square of the structure of variance, in case of heteroscedastic variance of the response}
}
\value{
A function depending on \code{x} that's the gradient of the \code{model} with respect to \code{char_vars}
}
\description{
Calculates the gradient function of a \code{model} with respect to the parameters, \code{char_vars}, evaluates
it at the provided \code{values} and returns the result as a function of the variable \code{x}.
}
