% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{update_weightsDS}
\alias{update_weightsDS}
\title{Update weight Ds-Optimality}
\usage{
update_weightsDS(design, sens, s, delta)
}
\arguments{
\item{design}{Design to optimize the weights from. It's a dataframe with two columns:
\itemize{
\item \code{Point} contains the support points of the design.
\item \code{Weight} contains the corresponding weights of the \code{Point}s.
}}

\item{sens}{Sensibility function for the design and model.}

\item{s}{Number of interest parameters of the model}

\item{delta}{A parameter of the algorithm that can be tuned. Must be \eqn{0< delta < 1}.}
}
\value{
returns the new weights of the design after one iteration.
}
\description{
Implementation of the weight update formula for Ds-Optimality used to optimize the weights of a design,
which is to be applied iteratively until no sizable changes happen.
}
