% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiwave.R
\name{multiwave}
\alias{multiwave}
\alias{new_multiwave}
\title{Initialize a Multiwave Object}
\usage{
multiwave(phases, waves, metadata = list(), phase1 = data.frame())

new_multiwave(phases, waves, metadata = list(), phase1 = data.frame())
}
\arguments{
\item{phases}{A numeric value specifying the number of phases in the
survey design.}

\item{waves}{A vector of numeric values specifying the number of waves in
each phase of the survey design. Length must match the number of
\code{phases} and the first}

\item{metadata}{A list containing the survey metadata.
Defaults to an empty list.}

\item{phase1}{A dataframe containing the phase 1 data of the survey.
Defaults to an empty dataframe.}
}
\value{
Returns an object of class \code{Multiwave} that stores all
relevant data from the survey design in an organized and easy-to-access
manner. See package vignettes or class documentation for more information.
}
\description{
\code{multiwave()} Creates an Object of Class \code{Multiwave} with the
specified number
of phases and waves. All contents will be NULL upon initialization,
but the object contains a framework for contents to be added to
during the survey design and sample collection process. Currently,
multiwave objects may only have one wave in Phase 1.
}
\examples{

# Initialize a multiwave object for a two-phase sampling design that will
# sample over three waves in the second phase
multiwave_object <- multiwave(phases = 2, waves = c(1, 3))

# If we already have the phase 1 data and want to add a title to the survey
# metadata, we can initialize the object with these included.

library(datasets)
multiwave_object <- multiwave(
  phases = 2, waves = c(1, 3),
  metadata = list(title = "my two-phase survey"), phase1 = iris
)
}
