% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{try_silent_timed}
\alias{try_silent_timed}
\title{Interruption of silently tried evaluations}
\usage{
try_silent_timed(expr, secs)
}
\arguments{
\item{expr}{An R expression to try.}

\item{secs}{The number of seconds.}
}
\value{
Either the value of \code{expr}, or (in case of a failure) an object of class
\code{fail} (which contains the error message), or \code{NULL} (if the
evaluation time exceeded \code{secs} seconds).
}
\description{
This function tries to evaluate \code{expr} and interrupts the try after
\code{secs} seconds.
}
\details{
This function is a wrapper for \code{\link{try_silent}} in combination with
\code{\link{timed}}.
}
\examples{
foo <- function(x, y) { Sys.sleep(x); return(x + y) }
try_silent_timed(foo(0.5, 1), 1)
try_silent_timed(foo(0.5, "1"), 1)
try_silent_timed(foo(1.5, 1), 1)

}
\keyword{internal}
\keyword{utils}
