% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mort_funs.R
\name{n_to_stock}
\alias{n_to_stock}
\title{Calculate the number of fish to stock based on desired recruit number
and given mortality curve}
\usage{
n_to_stock(
  time_at_stocking,
  time_at_rec,
  n_recruits_desired,
  mort_fun = exp_mort,
  mort_fun_args
)
}
\arguments{
\item{time_at_stocking}{The time that fish are stocked (i.e. synonymous with
the amount of time that fish are raised in a hatchery)}

\item{time_at_rec}{The time at which a fish enters the fishery (i.e. the
amount of time it takes a fish to grow to a desired length). Use
\code{\link{inv_vb}} to calculate this.}

\item{n_recruits_desired}{The number of recruits desired at
\code{time_at_rec}}

\item{mort_fun}{The mortality function, see ?mort_funs}

\item{mort_fun_args}{List. Named arguments to be passed to \code{mort_fun}}
}
\value{
The number of fish to be stocked at \code{time_at_stocking} to
get the desired number of fish at \code{time_at_rec} based on the mortality
function and associated parameters
}
\description{
This function is essentially the inverse of \code{\link{recruits_at_time}}.
Given the number of fish desired at a certain time and the mortality
function and parameters this function will calculate how many fish should be
stocked into a system.
}
\examples{
# how many fish to stock on day 100 if you want 10000 fish on day 1000
n_to_stock(10000, 100, 1000,
           mort_fun = exp_mort,
           mort_fun_args = list(m_init = (1 / 365),
                                m_inf = (0.2/365),
                                alpha = 0.005))
}
