% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matched.distances.R
\name{matched.distances}
\alias{matched.distances}
\title{Determine distances between matched units}
\usage{
matched.distances(matchobj, distance, preserve.unit.names = FALSE)
}
\arguments{
\item{matchobj}{Value of a call to \code{pairmatch} or
\code{fullmatch}.}

\item{distance}{Either a distance matrix or the value of a call to
or \code{match_on}.}

\item{preserve.unit.names}{Logical.  If TRUE, for each matched set
\code{matched.distances} returns the submatrix of the distance
matrix corresponding to it; if FALSE, a vector containing the
distances in that submatrix is returned.}
}
\value{
A list of numeric vectors (or matrices) of distances, one
  for each matched set.  Note that a matched set with 1 treatment
  and k controls, or with k treatments and 1 control, has k, not
  k+1, distances.
}
\description{
From a match (as produced by \code{pairmatch} or \code{fullmatch})
and a distance, extract the distances of matched units from their
matched counterparts.
}
\details{
From a match (as produced by \code{pairmatch} or \code{fullmatch})
and a distance, extract the distances of matched units from their
matched counterparts.
}
\examples{

data(plantdist)
plantsfm <- fullmatch(plantdist)
(plantsfm.d <- matched.distances(plantsfm,plantdist,pres=TRUE))
unlist(lapply(plantsfm.d, max))
mean(unlist(plantsfm.d))
}
\author{
Ben B. Hansen
}
\keyword{nonparametric}

