% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.optweight.R
\name{plot.optweight}
\alias{plot.optweight}
\alias{plot.optweightMV}
\alias{plot.optweight.svy}
\title{Plot Dual Variables for Assessing Balance Constraints}
\usage{
\method{plot}{optweight}(x, ...)

\method{plot}{optweightMV}(x, which.treat = 1, ...)

\method{plot}{optweight.svy}(x, ...)
}
\arguments{
\item{x}{an \code{optweight}, \code{optweightMV}, or \code{optweight.svy} object; the output of a
call to \code{\link[=optweight]{optweight()}}, \code{\link[=optweightMV]{optweightMV()}}, or \code{\link[=optweight.svy]{optweight.svy()}}.}

\item{\dots}{Ignored.}

\item{which.treat}{For \code{optweightMV} objects, which treatment to display.
Only one may be displayed at a time.}
}
\value{
A \code{ggplot} object that can be used with other \pkg{ggplot2} functions.
}
\description{
Plots the dual variables resulting from \code{\link[=optweight]{optweight()}} in a way similar to
figure 2 of Zubizarreta (2015), which explained how to interpret these
values. These represent the cost of changing the constraint on the variance
of the resulting weights. For covariates with large values of the dual
variable, tightening the constraint will increase the variability of the
weights, and loosening the constraint will decrease the variability of the
weights, both to a greater extent than would doing the same for covariate
with small values of the dual variable.
}
\examples{
\dontshow{if (requireNamespace("cobalt", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library("cobalt")
data("lalonde", package = "cobalt")

tols <- process_tols(treat ~ age + educ + married +
                       nodegree + re74, data = lalonde,
                     tols = .1)

#Balancing covariates between treatment groups (binary)
ow1 <- optweight(treat ~ age + educ + married +
                   nodegree + re74, data = lalonde,
                 tols = tols,
                 estimand = "ATT")

summary(ow1) # Note the RMSE Dev and effective
#              sample size (ESS)

plot(ow1) # age has a low value, married is high

tols["age"] <- 0
ow2 <- optweight(treat ~ age + educ + married +
                   nodegree + re74, data = lalonde,
                 tols = tols,
                 estimand = "ATT")

summary(ow2) # Notice that tightening the constraint
#              on age had a negligible effect on the
#              variability of the weights and ESS

tols["age"] <- .1
tols["married"] <- 0
ow3 <- optweight(treat ~ age + educ + married +
                   nodegree + re74, data = lalonde,
                 tols = tols,
                 estimand = "ATT")

summary(ow3) # In contrast, tightening the constraint
#              on married had a large effect on the
#              variability of the weights, shrinking
#              the ESS
\dontshow{\}) # examplesIf}
}
\references{
Zubizarreta, J. R. (2015). Stable Weights that Balance Covariates for Estimation With Incomplete Outcome Data. \emph{Journal of the American Statistical Association}, 110(511), 910–922. \doi{10.1080/01621459.2015.1023805}
}
\seealso{
\code{\link[=optweight]{optweight()}}, \code{\link[=optweightMV]{optweightMV()}}, or \code{\link[=optweight.svy]{optweight.svy()}} to estimate
the weights and the dual variables

\code{\link[=plot.summary.optweight]{plot.summary.optweight()}} for plots of the distribution of
weights
}
