% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ocmm.methods.R
\name{logLik.ocmm}
\alias{logLik.ocmm}
\title{Extract Log-likelihood for a Continuous Ordinal Mixed Model}
\usage{
\method{logLik}{ocmm}(object, ...)
}
\arguments{
\item{object}{an \code{ocmm} object}

\item{...}{further arguments to be passed to methods}
}
\value{
The log-likelihood of an \code{ocmm} object. This is a number with attributes
\item{df}{estimated degrees of freedom for the fitted model \code{object}}
\item{nobs}{number of observations used in the fitted model \code{object}}
\item{class}{class of the returned object: \code{logLik.ocmm}}
}
\description{
Extracts the log-likelihood for a fitted \code{ocmm} object
}
\examples{
\dontrun{
fit.overall.rnd  <- ocmm(overall  ~ cycleno + age + bsa + treatment + (1|randno), data=ANZ0001)
logLik(fit.overall.rnd)
}
}
\author{
Maurizio Manuguerra, Gillian Heller
}
\seealso{
\code{\link{ocmm}}
}

