% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_simulations.R
\name{run_simulations}
\alias{run_simulations}
\title{Run Simulations}
\usage{
run_simulations(
  sample_size,
  sample_prob,
  prob0,
  prob1,
  niter,
  included = "all",
  .rng_kind = NULL,
  .rng_normal_kind = NULL,
  .rng_sample_kind = NULL
)
}
\arguments{
\item{sample_size}{Total number of trial participants}

\item{sample_prob}{a vector of probability weights for obtaining the elements of the vector being sampled.}

\item{prob0}{Vector of probabilities for control group}

\item{prob1}{Vector of probabilities for intervention group}

\item{niter}{Number of simulation iterations to complete#'}

\item{included}{a character vector of the tests to be included. Default is "all"}

\item{.rng_kind}{seeding info passed to withr::with_seed}

\item{.rng_normal_kind}{seeding info passed to withr::with_seed}

\item{.rng_sample_kind}{seeding info passed to withr::with_seed}
}
\value{
a list of lists; sub-list elements include `p_values` which is a matrix of p values for tests at each iteration, and `initial_groups` which is the group assignment information for each iteration
}
\description{
Run Simulations
}
\examples{
run_simulations(
  sample_size = c(40, 50, 60),
  sample_prob = c(0.5, 0.5),
  prob0 = c(0.1, 0.2, 0.3, 0.4),
  prob1 = c(0.6, 0.2, 0.1, 0.1),
  niter = 40
)

}
