% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{ore_subst}
\alias{ore_subst}
\alias{ore.subst}
\alias{ore.repl}
\alias{ore_repl}
\title{Replace matched substrings with new text}
\usage{
ore_subst(regex, replacement, text, ..., all = FALSE, start = 1L)

ore_repl(regex, replacement, text, ..., all = FALSE, start = 1L,
  simplify = TRUE)
}
\arguments{
\item{regex}{A single character string or object of class \code{"ore"}. In
the former case, this will first be passed through \code{\link{ore}}.}

\item{replacement}{A character vector, or a function to be applied to the
matches.}

\item{text}{A vector of strings to match against.}

\item{...}{Further arguments to \code{replacement}, if it is a function.}

\item{all}{If \code{TRUE}, then all matches within each element of
\code{text} will be found. Otherwise, the search will stop at the first
match.}

\item{start}{An optional vector of offsets (in characters) at which to start
searching. Will be recycled to the length of \code{text}.}

\item{simplify}{For \code{ore_repl}, a character vector of modified strings
will be returned if this is \code{TRUE} and \code{text} is of length 1.
Otherwise, a list of such objects will always be returned.}
}
\value{
Versions of \code{text} with the substitutions made.
}
\description{
These functions substitute new text into strings in regions that match a
regular expression. The substitutions may be simple text, may include
references to matched subgroups, or may be created by an R function.
}
\details{
These functions differ in how they are vectorised. \code{ore_subst}
vectorises over matches, and returns a vector of the same length as the
\code{text} argument. If multiple replacements are given then they are
applied to matches in turn. \code{ore_repl} vectorises over replacements,
replicating the elements of \code{text} as needed, and (in general)
returns a list the same length as \code{text}, whose elements are character
vectors each of the same length as \code{replacement} (or its return value,
if a function). Each string combines the first replacement for each match,
the second, and so on.

If \code{replacement} is a character vector, its component strings may
include back-references to captured substrings. \code{"\\\\0"} corresponds
to the whole matching substring, \code{"\\\\1"} is the first captured
group, and so on. Named groups may be referenced as \code{"\\\\k<name>"}.

If \code{replacement} is a function, then it will be passed as its first
argument an object of class \code{"orearg"}. This is a character vector
containing as its elements the matched substrings, and with an attribute
containing the matches for parenthesised subgroups, if there are any. A
\code{\link{groups}} method is available for this class, so the groups
attribute can be easily obtained that way. The substitution function will be
called once per element of \code{text} by \code{ore_subst}, and once per
match by \code{ore_repl}.
}
\examples{
# Simple text substitution (produces "no dogs")
ore_subst("\\\\d+", "no", "2 dogs")

# Back-referenced substitution (produces "22 dogs")
ore_subst("(\\\\d+)", "\\\\1\\\\1", "2 dogs")

# Function-based substitution (produces "4 dogs")
ore_subst("\\\\d+", function(i) as.numeric(i)^2, "2 dogs")
}
\seealso{
\code{\link{ore_search}}
}
