% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qoffset_x.R, R/zzz_niftiImage.R
\docType{methods}
\name{qoffset_x-methods}
\alias{qoffset_x-methods}
\alias{qoffset_x-methods,}
\alias{qoffset_x}
\alias{qoffset_x,nifti-method}
\alias{qoffset_x<-}
\alias{qoffset_x<-,nifti-method}
\alias{qoffset.x}
\alias{qoffset.x,nifti-method}
\alias{qoffset.x<-}
\alias{qoffset.x<-,nifti-method}
\alias{qoffset_x,niftiImage-method}
\alias{qoffset_x<-,niftiImage-method}
\title{Extract Image Attribute \code{qoffset_x}}
\usage{
qoffset_x(object)

\S4method{qoffset_x}{nifti}(object)

qoffset_x(object) <- value

\S4method{qoffset_x}{nifti}(object) <- value

qoffset.x(object)

\S4method{qoffset.x}{nifti}(object)

qoffset.x(object) <- value

\S4method{qoffset.x}{nifti}(object) <- value

\S4method{qoffset_x}{niftiImage}(object)

\S4method{qoffset_x}{niftiImage}(object) <- value
}
\arguments{
\item{object}{is an object of class \code{nifti} or \code{anlz}.}

\item{value}{is the value to assign to the \code{qoffset_x} field.}
}
\description{
Methods that act on the \code{qoffset_x} field in the
NIfTI/ANALYZE header.
}
\details{
See documentation on the ANALYZE and/or NIfTI data standards for
more details.
}
\examples{
file = system.file("extdata", "example.nii.gz", package = "RNifti")
img = RNifti::readNifti(file)
qoffset_x(img)
qoffset_x(img) = 10
stopifnot(qoffset_x(img) == 10)
}
\references{
ANALYZE 7.5\cr
\url{http://eeg.sourceforge.net/ANALYZE75.pdf}\cr
NIfTI-1\cr
\url{http://nifti.nimh.nih.gov/}
}
\author{
John Muschelli \email{muschellij2@gmail.com},\cr
Brandon Whitcher \email{bwhitcher@gmail.com}
}
