% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osf_tbl.R
\name{osf_tbl}
\alias{osf_tbl}
\alias{osf_tbl_node}
\alias{osf_tbl_file}
\alias{osf_tbl_user}
\title{OSF Tibbles}
\description{
Items retrieved from OSF are represented as \code{osf_tbl} objects, specialized
data frames based on the \link[tibble:tibble-package]{tibble} class. See below
for additional details.
}
\details{
Each row of an \code{osf_tbl} represents a single OSF entity. This could be a
user, project, component, directory, or file. An \code{osf_tbl} must include
the following 3 columns:
\enumerate{
\item \code{name}: indicates the name or title of the entity.
\item \code{id}: the unique identifier assigned by OSF.
\item \code{meta}: a list-column that stores the processed response returned by OSF's
API. See the \emph{Meta column} section below for more information.
}
}
\section{Subclasses}{


\code{osf_tbl} is the parent class of 3 subclasses that are used to represent
each of OSF's main entities:
\enumerate{
\item \code{osf_tbl_user} for users.
\item \code{osf_tbl_file} for files and directories.
\item \code{osf_tbl_node} for projects and components.
}
}

\section{OSF nodes}{


Projects and components are both implemented as \emph{nodes} on OSF. The only
distinction between the two is that a project is a top-level node, and a
component must have a parent node (i.e., must be a sub-component of another
project or component). Because projects and components are functionally
identical, osfr uses the same \code{\link{osf_tbl_node}} class to represent both.
}

\section{Meta column}{


The \code{meta} column contains all of the information returned from OSF's API for
a single entity, structured as a named list with 3 elements:
\enumerate{
\item \code{attributes} contains metadata about the entity (e.g., names,
descriptions, tags, etc).
\item \code{links} contains urls to API endpoints with alternative representations of
the entity or actions that may be performed on the entity.
\item \code{relationships} contains URLs to other entities with relationships to the
entity (e.g., collaborators attached to a project).
}

This information is critical for \code{osfr}'s internal functions and should not
be altered by users. For even more information about these elements, see
\href{https://developer.osf.io/#tag/Entities-and-Entity-Collections}{OSF's API documentation}.
}

\section{Acknowledgments}{


Our implementation of the \code{osf_tbl} class is based on \code{dribble} objects from
the \href{https://googledrive.tidyverse.org}{googledrive} package.
}

