% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opq.R
\name{opq}
\alias{opq}
\title{Build an Overpass query}
\usage{
opq(bbox = NULL, timeout = 25, memsize)
}
\arguments{
\item{bbox}{Either (i) four numeric values specifying the maximal and minimal
longitudes and latitudes; (ii) a character string passed to
\link{getbb} to be converted to a numerical bounding box; or
(iii) a matrix representing a bounding polygon as returned from
\code{getbb(..., format_out = "polygon")}.}

\item{timeout}{It may be necessary to ncrease this value for large queries,
because the server may time out before all data are delivered.}

\item{memsize}{The default memory size for the 'overpass' server in
\emph{bytes}; may need to be increased in order to handle large
queries.}
}
\value{
An \code{overpass_query} object
}
\description{
Build an Overpass query
}
\note{
See
\url{https://wiki.openstreetmap.org/wiki/Overpass_API#Resource_management_options_.28osm-script.29}
for explanation of \code{timeout} and \code{memsize} (or \code{maxsize} in
overpass terms). Note in particular the comment that queries with arbitrarily
large \code{memsize} are likely to be rejeted.
}
\examples{
\dontrun{
q <- getbb ("portsmouth", display_name_contains = "USA") \%>\%
            opq () \%>\% 
            add_osm_feature("amenity", "restaurant") \%>\%
            add_osm_feature("amenity", "pub") 
osmdata_sf (q) # all objects that are restaurants AND pubs (there are none!)
q1 <- getbb ("portsmouth", display_name_contains = "USA") \%>\%
                opq () \%>\% 
                add_osm_feature("amenity", "restaurant") 
q2 <- getbb ("portsmouth", display_name_contains = "USA") \%>\%
                opq () \%>\% 
                add_osm_feature("amenity", "pub") 
c (osmdata_sf (q1), osmdata_sf (q2)) # all objects that are restaurants OR pubs
}
}
