% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opq.R
\name{add_osm_features}
\alias{add_osm_features}
\title{Add multiple features to an Overpass query}
\usage{
add_osm_features(
  opq,
  features,
  bbox = NULL,
  key_exact = TRUE,
  value_exact = TRUE
)
}
\arguments{
\item{opq}{An \code{overpass_query} object}

\item{features}{A named list or vector with the format \code{list("<key>" = "<value>")} or \code{c("<key>" = "<value>")} or a character vector of
key-value pairs with keys and values enclosed in escape-formatted
quotations. See examples for details.}

\item{bbox}{optional bounding box for the feature query; must be set if no
opq query bbox has been set.}

\item{key_exact}{If FALSE, \code{key} is not interpreted exactly; see
\url{https://wiki.openstreetmap.org/wiki/Overpass_API}}

\item{value_exact}{If FALSE, \code{value} is not interpreted exactly}
}
\value{
\link{opq} object
}
\description{
Alternative version of \link{add_osm_feature} for creating single queries
with multiple features. Key-value matching may be controlled by using the
filter symbols described in
\url{https://wiki.openstreetmap.org/wiki/Overpass_API/Overpass_QL#By_tag_.28has-kv.29}.
}
\section{\code{add_osm_feature} vs \code{add_osm_features}}{

Features defined within an \link{add_osm_features} call are combined with a
logical OR.

Chained calls to either \link{add_osm_feature} or \code{add_osm_features()} combines
features from these calls in a logical AND; this is analagous to chaining
\code{dplyr::filter()} on a data frame.

\code{add_osm_features()} with only one feature is logically equivalent to
\code{add_osm_feature()}.
}

\examples{
\dontrun{
q <- opq ("portsmouth usa") \%>\%
    add_osm_features (features = list (
        "amenity" = "restaurant",
        "amenity" = "pub"
    ))

q <- opq ("portsmouth usa") \%>\%
    add_osm_features (features = c (
        "\"amenity\"=\"restaurant\"",
        "\"amenity\"=\"pub\""
    ))
# This extracts in a single query the same result as the following:
q1 <- opq ("portsmouth usa") \%>\%
    add_osm_feature (
        key = "amenity",
        value = "restaurant"
    )
q2 <- opq ("portsmouth usa") \%>\%
    add_osm_feature (key = "amenity", value = "pub")
c (osmdata_sf (q1), osmdata_sf (q2)) # all restaurants OR pubs
}
}
\references{
\url{https://wiki.openstreetmap.org/wiki/Map_Features}
}
\seealso{
\link{add_osm_feature}

Other queries: 
\code{\link{add_osm_feature}()},
\code{\link{bbox_to_string}()},
\code{\link{getbb}()},
\code{\link{opq_around}()},
\code{\link{opq_csv}()},
\code{\link{opq_enclosing}()},
\code{\link{opq_osm_id}()},
\code{\link{opq_string}()},
\code{\link{opq}()},
\code{\link{overpass_status}()}
}
\concept{queries}
