% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{oe_read}
\alias{oe_read}
\title{Read a .pbf or .gpkg object from file or url}
\usage{
oe_read(
  file_path,
  layer = "lines",
  ...,
  provider = NULL,
  download_directory = oe_download_directory(),
  file_size = NULL,
  force_download = FALSE,
  max_file_size = 5e+08,
  download_only = FALSE,
  skip_vectortranslate = FALSE,
  vectortranslate_options = NULL,
  osmconf_ini = NULL,
  extra_tags = NULL,
  force_vectortranslate = FALSE,
  never_skip_vectortranslate = FALSE,
  boundary = NULL,
  boundary_type = c("spat", "clipsrc"),
  quiet = FALSE
)
}
\arguments{
\item{file_path}{A URL or the path to a \code{.pbf} or \code{.gpkg} file. If a URL,
then it must be specified using HTTP/HTTPS protocol.}

\item{layer}{Which \code{layer} should be read in? Typically \code{points}, \code{lines}
(the default), \code{multilinestrings}, \code{multipolygons} or \code{other_relations}. If
you specify an ad-hoc query using the argument \code{query} (see introductory
vignette and examples), then \code{\link[=oe_get]{oe_get()}} and \code{\link[=oe_read]{oe_read()}} will read the layer
specified in the query and ignore \code{layer} argument. See also
\href{https://github.com/ropensci/osmextract/issues/122}{#122}.}

\item{...}{(Named) arguments that will be passed to \code{\link[sf:st_read]{sf::st_read()}}, like
\code{query}, \code{wkt_filter} or \code{stringsAsFactors}.  Check the introductory
vignette to understand how to create your own (SQL-like) queries.}

\item{provider}{Which provider should be used to download the data? Available
providers can be browsed with \code{\link[=oe_providers]{oe_providers()}}. For \code{\link[=oe_get]{oe_get()}} and
\code{\link[=oe_match]{oe_match()}}, if \code{place} is equal to \verb{ITS Leeds}, then \code{provider} is
internally set equal to \code{"test"}. This is just for simple examples and
internal tests.}

\item{download_directory}{Directory to store the file containing OSM data?.}

\item{file_size}{How big is the file? Optional. \code{NA} by default. If it's
bigger than \code{max_file_size} and the function is run in interactive mode,
then an interactive menu is displayed, asking for permission to download
the file.}

\item{force_download}{Should the \code{.osm.pbf} file be updated even if it has
already been downloaded? \code{FALSE} by default. This parameter is used to
update old \code{.osm.pbf} files.}

\item{max_file_size}{The maximum file size to download without asking in
interactive mode. Default: \code{5e+8}, half a gigabyte.}

\item{download_only}{Boolean. If \code{TRUE}, then the function only returns the
path where the matched file is stored, instead of reading it. \code{FALSE} by
default.}

\item{skip_vectortranslate}{Boolean. If \code{TRUE}, then the function skips all
vectortranslate operations and it reads (or simply returns the path) of the
\code{.osm.pbf} file. \code{FALSE} by default.}

\item{vectortranslate_options}{Options passed to the \code{\link[sf:gdal_utils]{sf::gdal_utils()}}
argument \code{options}. Set by default. Check details in the introductory
vignette and the help page of \code{\link[=oe_vectortranslate]{oe_vectortranslate()}}.}

\item{osmconf_ini}{The configuration file. See documentation at
\href{https://gdal.org/en/stable/drivers/vector/osm.html}{gdal.org}. Check details in the
introductory vignette and the help page of \code{\link[=oe_vectortranslate]{oe_vectortranslate()}}. Set by
default.}

\item{extra_tags}{Which additional columns, corresponding to OSM tags, should
be in the resulting dataset? \code{NULL} by default. Check the introductory
vignette and the help pages of \code{\link[=oe_vectortranslate]{oe_vectortranslate()}} and \code{\link[=oe_get_keys]{oe_get_keys()}}.
Ignored when \code{osmconf_ini} is not \code{NULL}.}

\item{force_vectortranslate}{Boolean. Force the original \code{.pbf} file to be
translated into a \code{.gpkg} file, even if a \code{.gpkg} with the same name
already exists? \code{FALSE} by default. If tags in \code{extra_tags} match data in
previously translated \code{.gpkg} files no translation occurs (see
\href{https://github.com/ropensci/osmextract/issues/173}{#173} for details).
Check the introductory vignette and the help page of
\code{\link[=oe_vectortranslate]{oe_vectortranslate()}}.}

\item{never_skip_vectortranslate}{Boolean. This is used in case the user
passed its own \code{.ini} file or vectortranslate options (since, in those
case, it's too difficult to determine if an existing \code{.gpkg} file was
generated following the same options.)}

\item{boundary}{An \code{sf}/\code{sfc}/\code{bbox} object that will be used to create a
spatial filter during the vectortranslate operations. The type of filter
can be chosen using the argument \code{boundary_type}.}

\item{boundary_type}{A character vector of length 1 specifying the type of
spatial filter. The \code{spat} filter selects only those features that
intersect a given area, while \code{clipsrc} also clips the geometries. Check
the examples and also \href{https://gdal.org/en/stable/programs/ogr2ogr.html}{here} for
more details.}

\item{quiet}{Boolean. If \code{FALSE}, the function prints informative messages.
Starting from \code{sf} version
\href{https://r-spatial.github.io/sf/news/index.html#version-0-9-6-2020-09-13}{0.9.6},
if \code{quiet} is equal to \code{FALSE}, then vectortranslate operations will
display a progress bar.}
}
\value{
An \code{sf} object or, when \code{download_only} argument equals \code{TRUE}, a
character vector.
}
\description{
This function is used to read a \code{.pbf} or \code{.gpkg} object from file or URL. It
is a wrapper around \code{\link[=oe_download]{oe_download()}}, \code{\link[=oe_vectortranslate]{oe_vectortranslate()}}, and
\code{\link[sf:st_read]{sf::st_read()}}, creating an easy way to download, convert, and read a \code{.pbf}
or \code{.gpkg} file. Check the introductory vignette and the help pages of the
wrapped function for more details.
}
\details{
The arguments \code{provider}, \code{download_directory}, \code{file_size},
\code{force_download}, and \code{max_file_size} are ignored if \code{file_path} points to
an existing \code{.pbf} or \code{.gpkg} file.

Please note that you cannot add any field to an existing \code{.gpkg} file using
the argument \code{extra_tags} without rerunning the vectortranslate process on
the corresponding \code{.pbf} file. On the other hand, you can extract some of
the tags in \code{other_tags} field as new columns. See examples and
\code{\link[=oe_get_keys]{oe_get_keys()}} for more details.
}
\examples{
# Read an existing .pbf file. First we need to copy a .pbf file into a
# temporary directory
its_pbf = file.path(tempdir(), "test_its-example.osm.pbf")
file.copy(
  from = system.file("its-example.osm.pbf", package = "osmextract"),
  to = its_pbf
)
oe_read(its_pbf)

# Read a new layer
oe_read(its_pbf, layer = "points")

# The following example shows how to add new tags
names(oe_read(its_pbf, extra_tags = c("oneway", "ref"), quiet = TRUE))

# Read an existing .gpkg file. This file was created internally by oe_read().
its_gpkg = file.path(tempdir(), "test_its-example.gpkg")
oe_read(its_gpkg)

# You cannot add any new layer to an existing .gpkg file but you can extract
# some of the tags in other_tags. Check oe_get_keys() for more details.
names(oe_read(its_gpkg, extra_tags = c("maxspeed"))) # doesn't work
# Instead, use the query argument
names(oe_read(
  its_gpkg,
  quiet = TRUE,
  query =
  "SELECT *,
  hstore_get_value(other_tags, 'maxspeed') AS maxspeed
  FROM lines
  "
))

# Read from a URL
my_url = "https://github.com/ropensci/osmextract/raw/master/inst/its-example.osm.pbf"
# Please note that if you read from a URL which is not linked to one of the
# supported providers, you need to specify the provider parameter:
\dontrun{
oe_read(my_url, provider = "test", quiet = FALSE)}

# Remove .pbf and .gpkg files in tempdir
oe_clean(tempdir())
}
