% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enum.R
\name{enumPut}
\alias{enumPut}
\title{Add a new key-value pairs to an \code{enum}}
\usage{
enumPut(keys, values, enum, overwrite = FALSE)
}
\arguments{
\item{keys}{Keys of the values to be added}

\item{values}{Values to be added}

\item{enum}{The enum to which the specified key-value pairs should be added.
\strong{WARNING}: the original object is \strong{not} modified!}

\item{overwrite}{If \code{TRUE} and a value with any of the given \code{keys} exists,
it will be overwritten with the new value. Otherwise, an error is thrown.
Default is \code{FALSE.}}
}
\value{
\code{Enum} with added key-value pair.
}
\description{
Add a new key-value pairs to an \code{enum}
}
\examples{
myEnum <- enum(c(a = "b"))
myEnum <- enumPut("c", "d", myEnum)
myEnum <- enumPut(c("c", "d", "g"), c(12, 2, "a"), myEnum, overwrite = TRUE)
}
\seealso{
Other enumeration-helpers: 
\code{\link{enumGetKey}()},
\code{\link{enumGetValue}()},
\code{\link{enumHasKey}()},
\code{\link{enumKeys}()},
\code{\link{enumRemove}()},
\code{\link{enumValues}()},
\code{\link{enum}()}
}
\concept{enumeration-helpers}
