% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrmTrip.R
\name{osrmTrip}
\alias{osrmTrip}
\title{Get the Travel Geometry Between Multiple Unordered Points}
\usage{
osrmTrip(loc, overview = "simplified")
}
\arguments{
\item{loc}{a SpatialPointsDataFrame of the waypoints, or a data.frame with points as rows
and 3 columns: identifier, longitudes and latitudes (WGS84 decimal degrees).}

\item{overview}{"full", "simplified". Add geometry either full (detailed) or simplified 
according to highest zoom level it could be display on.}
}
\value{
A list of connected components. Each component contains:

\describe{
\item{trip}{A SpatialLinesDataFrame (loc's CRS if there is one, WGS84 else)
containing a line for each step of the trip.}
\item{summary}{A list with 2 components: duration (in minutes)
and distance (in kilometers).}
}
}
\description{
Build and send an OSRM API query to get the shortest travel geometry between multiple points.
This function interfaces the \emph{trip} OSRM service.
}
\details{
As stated in the OSRM API, if input coordinates can not be joined by a single trip 
(e.g. the coordinates are on several disconnecte islands) multiple trips for 
each connected component are returned.
}
\examples{
\dontrun{
# Load data
data("com")

# Get a trip with a id lat lon data.frame
trips <- osrmTrip(loc = com[1101:1150, c(1,3,4)])

# Display the trip
plot(trips[[1]]$trip , col = 1:5)
points(com[1101:1150, 3:4], pch = 20, col = "red", cex = 0.5)

# Map
if(require("cartography")){
  osm <- getTiles(spdf = trips[[1]]$trip, crop = TRUE, type = "osmgrayscale")
  tilesLayer(osm)
  plot(trips[[1]]$trip, col = 1:5, add = TRUE)
  points(com[1101:1150, 3:4], pch = 20, col = "red", cex = 0.5)
}

# Get a trip with a SpatialPointsDataFrame
trips <- osrmTrip(loc = src)

# Map
if(require("cartography")){
  osm <- getTiles(spdf = trips[[1]]$trip, crop = TRUE, type = "osmgrayscale")
  tilesLayer(osm)
  plot(src, pch = 20, col = "red", cex = 2, add = TRUE)
  plot(trips[[1]]$trip, col = 1:5, add = TRUE, lwd=2)
}
}
}
\seealso{
\link{osrmRoute}
}
