% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrmTrip.R
\name{osrmTrip}
\alias{osrmTrip}
\title{Get the Travel Geometry Between Multiple Unordered Points}
\usage{
osrmTrip(loc, exclude = NULL, overview = "simplified")
}
\arguments{
\item{loc}{a SpatialPointsDataFrame of the waypoints, or a data.frame with points as rows
and 3 columns: identifier, longitudes and latitudes (WGS84 decimal degrees).}

\item{exclude}{pass an optional "exclude" request option to the OSRM API.}

\item{overview}{"full", "simplified". Add geometry either full (detailed) or simplified 
according to highest zoom level it could be display on.}
}
\value{
A list of connected components. Each component contains:

\describe{
\item{trip}{A SpatialLinesDataFrame (loc's CRS if there is one, WGS84 else)
containing a line for each step of the trip.}
\item{summary}{A list with 2 components: duration (in minutes)
and distance (in kilometers).}
}
}
\description{
Build and send an OSRM API query to get the shortest travel geometry between multiple points.
This function interfaces the \emph{trip} OSRM service.
}
\details{
As stated in the OSRM API, if input coordinates can not be joined by a single trip 
(e.g. the coordinates are on several disconnecte islands) multiple trips for 
each connected component are returned.
}
\examples{
\dontrun{
# Load data
data("berlin")

# Get a trip with a id lat lon data.frame
trips <- osrmTrip(loc = apotheke.df)

# Display the trip
library(sp)
plot(trips[[1]]$trip, col = "black", lwd = 4)
plot(trips[[1]]$trip, col = c("red", "white"), lwd = 1, add=T)
points(apotheke.df[, 2:3], pch = 21, bg = "red", cex = 1)

# Do not route through motorways
trips_no_motorway <- osrmTrip(loc = apotheke.df, exclude = "motorway")

# Looks like it may be convenient to avoid motorways...
mapply(`/`, trips_no_motorway[[1]]$summary, trips[[1]]$summary)

# Display the trips
plot(trips[[1]]$trip, col = "black", lwd = 3)
plot(trips_no_motorway[[1]]$trip, col = "green", lwd = 3, add = T)
points(apotheke.df[, 2:3], pch = 21, bg = "red", cex = 1)

# Map
if(require("cartography")){
  osm <- getTiles(x = trips[[1]]$trip, crop = TRUE,
                  type = "cartolight", zoom = 11)
  tilesLayer(x = osm)
  plot(trips[[1]]$trip, col = "black", lwd = 4, add=T)
  plot(trips[[1]]$trip, col = c("red", "white"), lwd = 1, add=T)
  points(apotheke.df[, 2:3], pch = 21, bg = "red", cex = 1)
}

# Get a trip with a SpatialPointsDataFrame
trips <- osrmTrip(loc = apotheke.sp[1:10,])

# Map
if(require("cartography")){
  osm <- getTiles(x = trips[[1]]$trip, crop = TRUE,
                  type = "cartolight", zoom = 11)
  tilesLayer(x = osm)
  plot(trips[[1]]$trip, col = "black", lwd = 4, add=T)
  plot(trips[[1]]$trip, col = c("red", "white"), lwd = 1, add=T)
  plot(apotheke.sp[1:10,], pch = 21, bg = "red", cex = 1, add=T)
}
}
}
\seealso{
\link{osrmRoute}
}
