% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otp_get_distance.R
\name{otp_get_distance}
\alias{otp_get_distance}
\title{Finds the distance in metres between supplied origin and destination}
\usage{
otp_get_distance(otpcon, fromPlace, toPlace, mode = "CAR")
}
\arguments{
\item{otpcon}{An OTP connection object produced by \code{\link{otp_connect}}.}

\item{fromPlace}{Numeric vector, Latitude/Longitude pair, e.g. `c(53.48805, -2.24258)`}

\item{toPlace}{Numeric vector, Latitude/Longitude pair, e.g. `c(53.36484, -2.27108)`}

\item{mode}{Character vector, single mode of travel. Valid values are WALK, BICYCLE, or CAR. Default is CAR.}
}
\value{
If OTP has not returned an error then a list containing \code{errorId}
with the value "OK" and the \code{distance} in metres. If OTP has returned an
error then a list containing \code{errorId} with the OTP error code and \code{errorMessage}
with the error message returned by OTP.
}
\description{
Finds the distance in metres between supplied origin and destination. Only makes
sense for walk, cycle or car modes (not transit)
}
\examples{
\dontrun{
otp_get_distance(otpcon, fromPlace = c(53.48805, -2.24258), toPlace = c(53.36484, -2.27108))

otp_get_distance(otpcon, fromPlace = c(53.48805, -2.24258), toPlace = c(53.36484, -2.27108),
mode = "WALK")
}
}
