% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outbreaker_data.R
\name{outbreaker_data}
\alias{outbreaker_data}
\title{Process input data for outbreaker}
\usage{
outbreaker_data(..., data = list(...))
}
\arguments{
\item{...}{a list of data items to be processed (see description)}

\item{data}{optionally, an existing list of data item as returned by \code{outbreaker_data}.}
}
\description{
This function performs various checks on input data given to outbreaker.  It
takes a list of named items as input, performs various checks, set defaults
where arguments are missing, and return a correct list of data input. If no
input is given, it returns the default settings.
}
\details{
Acceptables arguments for ... are:
\describe{
\item{dates}{dates a vector indicating the collection dates, provided either as
integer numbers or in a usual date format such as \code{Date} or
\code{POSIXct} format. By convention, zero will indicate the oldest date.}

\item{dna}{the DNA sequences in \code{DNAbin} format (see
\code{\link[ape]{read.dna}} in the ape package); this can be imported from a
fasta file (extension .fa, .fas, or .fasta) using \code{adegenet}'s function
\link[adegenet]{fasta2DNAbin}.}

\item{ctd}{the contact tracing data provided as a matrix or dataframe of two
columns, indicating a reported contact between the two individuals whose ids
are provided in a given row of the data.}

\item{w_dens}{a vector of numeric values indicating the generation time
distribution, reflecting the infectious potential of a case t = 1, 2, ...
time steps after infection. By convention, it is assumed that
newly infected patients cannot see new infections on the same time step. If not
standardized, this distribution is rescaled to sum to 1.}

\item{f_dens}{similar to \code{w_dens}, except that this is the distribution
of the colonization time, i_e. time interval during which the pathogen can
be sampled from the patient.}

}
}
\examples{

x <- fake_outbreak
outbreaker_data(dates = x$sample, dna = x$dna, w_dens = x$w)

}
\author{
Thibaut Jombart (\email{thibautjombart@gmail.com})
}
