% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overview_heat.R
\name{overview_heat}
\alias{overview_heat}
\title{overview_heat}
\usage{
overview_heat(
  dat,
  id,
  time,
  perc = FALSE,
  exp_total,
  xaxis = "Time frame",
  yaxis = "Sample",
  col_low = "#dceaf2",
  col_high = "#2A5773"
)
}
\arguments{
\item{dat}{Your dataset}

\item{id}{Your scope (e.g., country codes or individual IDs)}

\item{time}{Your time (e.g., time periods given by years, months, ...)}

\item{perc}{If FALSE (default) plot returns the total number of observations
per time-scope-unit. If TRUE it returns the number of observations per
time-scope-unit in percentage}

\item{exp_total}{Expected total number of observations (i.e. maximum)
for time unit.}

\item{xaxis}{Label of your x axis ("Time frame" is default)}

\item{yaxis}{Label of your y axis ("Sample" is default)}

\item{col_low}{Hex color code for the lowest value (default is "#dceaf2")}

\item{col_high}{Hex color code for the lowest value (default is "#2A5773")}
}
\value{
A ggplot figure that presents sample coverage visually
}
\description{
This function plots a heat map to visualize the
    coverage of the time-scope-units of the data. Options include total
    number of cases per time-scope-unit or relative number in percentage.
}
\examples{
data(toydata)
overview_heat(toydata, ccode, year, perc = TRUE, exp_total = 12)
}
