% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WPSCapabilities.R
\docType{class}
\name{WPSCapabilities}
\alias{WPSCapabilities}
\title{WPSCapabilities}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for interfacing an OGC
Web Processing Service (WPS) Get Capabilities document.
}
\description{
WPSCapabilities
}
\note{
Class used to read a \code{WPSCapabilities} document. The use of \code{WPSClient} is
recommended instead to benefit from the full set of capabilities associated to a WPS server.
}
\section{Methods}{

\describe{
 \item{\code{new(url, version, logger, ...)}}{
   This method is used to instantiate a WPSCapabilities object
 }
 \item{\code{getProcesses(pretty, full)}}{
   Return the list of processes offered by the service capabilities. \code{pretty} allows to control
   the type output. If \code{TRUE}, a \code{data.frame} will be returned. When prettified output, it
   is also possible to get a 'full' description of the process by setting \code{full = TRUE} in which 
   case a the WPS client will request a process description (with more information about the process) for
   each process listed in the capabilities.
 }
 \item{\code{describeProcess(identifier)}}{
   Get the description of a process, given its \code{identifier}, returning an object of class \code{WPSProcessDescription}
 }
 \item{\code{execute(identifier, dataInputs, responseForm, storeExecuteResponse, lineage, status,
                     update, updateInterval)}}{
   Execute a process, given its \code{identifier}
 }
}
}

\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{Capabilities}
\keyword{OGC}
\keyword{WPS}
