% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphaAlgoritm.R
\name{alphaAlgorithm}
\alias{alphaAlgorithm}
\title{AlphaAlgoritm class}
\usage{
alphaAlgorithm(parameters.list = NA)
}
\arguments{
\item{parameters.list}{a list containing possible parameters to tune the model. At the moment no parameters are admitted for this model: this is implemented for further improvements.}
}
\description{
An implementation of an AlphaAlgorith (AA) model. Written with closures it provides also a set of
              ancillary methods for building/handling models. The methods are:
             \itemize{
             \item \code{alphaAlgorithm( ... ) } is the costructor
             \item \code{loadDataset( ... ) } loads data into an AA object.
             \item \code{trainModel( ... ) } trains an AA model
             \item \code{getModel() } returns the AA model (XML or graphical way, via grViz script)
             \item \code{replay( ... ) } submits to the model a set of given sequences and returns the fitting
             \item \code{play( ... ) } generates a wished number of sequences
             \item \code{plot() } plots the graph
             \item \code{distanceFrom( ... ) } calculates the distance between two different AA model objects
             }
             There are two ways to use this class: directly using the methods previously 
             listed or via wrapping functions (called PM.<method name>). In the examples section you will find an example of both.
}
\examples{
\dontrun{
# -----------------------------------------------
#  USING THE METHODS of the class
# -----------------------------------------------
obj.L<-dataLoader();   # create a Loader

# Load a .csv using "DES" and "ID" as column names to indeicate events 
# and Patient's ID
obj.L$loader(nomeFile = "./otherFiles/test_02.csv",IDName = "ID",
EVENTName = "DES")

# now create an object AlphaAlgorithm
obj.AA<-alphaAlgorithm();    

# load the data into AA model
obj.AA$loadDataset( obj.L$getData() );  

# train the model
obj.AA$trainModel();  

# plot the model 
obj.AA$plot();  

# -----------------------------------------------
#  USING THE WRAPPER Functions
# -----------------------------------------------
# Instantiate a loader
obj.LD<-LD.builder()

# Load a CSV into the loader
LD.load.csv(loader.obj = obj.LD ,nomeFile = "./otherFiles/test_02.csv",
     IDName = "ID",EVENTName = "DES")

# Instantiate a PM model
obj.PM <-PM.builder(kindOfObject = "alphaAlgorithm")

# Load the PM model
PM.loadDataset(PM.obj = obj.PM,dataList = LD.getData(loader.obj = obj.LD))

# train it
PM.trainModel(PM.obj = obj.PM)

# plot the model 
PM.plot(PM.obj = obj.PM)
}
}

