% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_spacetime.R
\name{subset_spacetime}
\alias{subset_spacetime}
\title{Subset a precipitation data product in time and space}
\usage{
subset_spacetime(data, years, bbox, autosave = FALSE)
}
\arguments{
\item{data}{a character string with the path to the data file. Or a RasterBrick}

\item{years}{numeric vector. Time range in the form: (start_year, end_year)}

\item{bbox}{numeric vector. Bounding box in the form: (xmin, xmax, ymin, ymax).}

\item{autosave}{logical FALSE (default). If TRUE data will be automatically stored in the same location of the input file}
}
\value{
A subsetted RasterBrick.
}
\description{
The function \code{subset_spacetime} subsets (time and space) the requested data set and stores it in the same location of the input file.
}
\examples{
\dontrun{
subset_spacetime("gpcp_tp_mm_global_197901_202205_025_monthly.nc",
c(2000, 2010), c(12.24, 18.85, 48.56, 51.12), autosave = TRUE)
subset_spacetime("dummie.nc", c(2000, 2010), 
c(12.24, 18.85, 48.56, 51.12), autosave = TRUE)
}
}
